import { _decorator, Collider, Component, ICollisionEvent, Node,Vec3 } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('CoinScript')
export class CoinScript extends Component {
    start() {
        let collider = this.node.getComponent(Collider);
        collider.on("onCollisionStay",this.onCollision,this);
        collider.on("onCollisionEnter",this.onCollisionEnter,this);
        collider.on("onCollisionExit",this.onCollisionExit,this);
    }
    onCollision(event:ICollisionEvent){
        console.log(event.type,event+" collision stay");
    }
    onCollisionEnter(event:ICollisionEvent){
        console.log(event.type,event+" collision Enter");
        this.node.destroy();
    }
    onCollisionExit(event:ICollisionEvent){
        console.log(event.type,event+" collision Exit");
    }

    update(deltaTime: number) {
       /* const currentPosition = this.node.position;
        const moveAmount = new Vec3(0,0,0.1);
        Vec3.add(currentPosition,currentPosition,moveAmount);
        this.node.setPosition(currentPosition);
        */
    }
}


