import { _decorator, Component, instantiate, Node, Prefab,Vec3} from 'cc';
const { ccclass, property } = _decorator;

@ccclass('GameManager')
export class GameManager extends Component {
    @property(Prefab)
    roadPrefab:Prefab = null;


    @property(Prefab)
    coinPrefab:Prefab = null;

    @property(Prefab)
    treePrefab:Prefab = null;

    onLoad(){
        for(let i=0;i<100;i++){
            const instantiatedNode = instantiate(this.roadPrefab);
            instantiatedNode.setPosition(0,0,i * -10);
            this.node.addChild(instantiatedNode);


            //coin generation
            const instantiatedCoin = instantiate(this.coinPrefab);
            const options = [3.5,0,-3.5];
            const randomNumber = this.getRandomNumber(options);
            instantiatedCoin.setPosition(randomNumber,2,i*-10);
            this.node.addChild(instantiatedCoin);
        }

        for(let b = 0; b<100;b++){
            //left side of the road
            const instantiatedTree = instantiate(this.treePrefab);
            const options2 = [-6.5,-6.8,-7, -7.3,-7.5];
            const randomNumber2 =this.getRandomNumber(options2);
            instantiatedTree.setPosition(randomNumber2,0,b*-10);

            const randomInteger = Math.floor(Math.random()*360);
            const rotationEuler = new Vec3(0,randomInteger,0);
            instantiatedTree.setRotationFromEuler(rotationEuler);
            this.node.addChild(instantiatedTree)

           
            //right side of the road
            const instantiatedTree2 = instantiate(this.treePrefab);
            const options3 = [6.5,6.8,7, 7.3,7.5];
            const randomNumber3 =this.getRandomNumber(options3);
            instantiatedTree2.setPosition(randomNumber3,0,b*-10);

            const randomInteger2 = Math.floor(Math.random()*360);
            const rotationEuler2 = new Vec3(0,randomInteger2,0);
            instantiatedTree2.setRotationFromEuler(rotationEuler2);
            this.node.addChild(instantiatedTree2);
        }
    }

    getRandomNumber(options:number[]):number{
        const randomIndex = Math.floor(Math.random()*options.length);
        return options[randomIndex];
    }
    start() {

    }

    update(deltaTime: number) {
        
    }
}


