import { _decorator,input, Component, Node, Input, EventKeyboard, KeyCode, Event, Vec3, Label,Collider,ICollisionEvent } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('PlayerScript')
export class PlayerScript extends Component {
    private isRightKeyPressed:boolean = false;
    private isLeftKeyPressed:boolean = false;

    private score:number = 0;
    @property(Label)
    scoreLabel:Label = null;
    onLoad(){
        input.on(Input.EventType.KEY_DOWN,this.onKeyDown,this);
        input.on(Input.EventType.KEY_UP,this.onKeyUp,this);
    }
    onDestroy(){
        input.off(Input.EventType.KEY_DOWN,this.onKeyDown,this);
        input.off(Input.EventType.KEY_UP,this.onKeyUp,this);
    }
    onKeyDown(event:EventKeyboard){
        switch(event.keyCode){
            case KeyCode.ARROW_LEFT:
                console.log("left key pressed");
                this.isLeftKeyPressed = true;
                break;
            case KeyCode.ARROW_RIGHT:
                console.log("right key pressed");
                this.isRightKeyPressed = true;
                break;
        }
    }
    onKeyUp(event:EventKeyboard){
        const newTargetRotation = new Vec3(0,180,0);
        switch(event.keyCode){
            case KeyCode.ARROW_LEFT:
                console.log("left key released");
                this.isLeftKeyPressed = false;
                this.node.eulerAngles=newTargetRotation;
                break;
            case KeyCode.ARROW_RIGHT:
                console.log("right key released");
                this.isRightKeyPressed = false;
                this.node.eulerAngles=newTargetRotation;
                break;
        }
    }


    start() {
        let collider = this.node.getComponent(Collider);
        collider.on("onCollisionStay",this.onCollision,this);
        collider.on("onCollisionEnter",this.onCollisionEnter,this);
        collider.on("onCollisionExit",this.onCollisionExit,this);
    }
    onCollision(event:ICollisionEvent){
        console.log(event.type,event+" collision stay");
    }
    onCollisionEnter(event:ICollisionEvent){
        console.log(event.type,event+" collision Enter");
        this.addScore();
    }
    onCollisionExit(event:ICollisionEvent){
        console.log(event.type,event+" collision Exit");
    }
    addScore(){
        this.score++;
        this.scoreLabel.string = "Score : "+this.score;
    }

    update(deltaTime: number) {
        const currentPosition = this.node.position;
        const moveAmount = new Vec3(0,0,-0.1);
        Vec3.add(currentPosition,currentPosition,moveAmount);
        this.node.setPosition(currentPosition);

        if(this.isRightKeyPressed && this.node.position.x<4.5){
            const currentPosition = this.node.position;
            const moveAmount = new Vec3(0.1,0,0);
            Vec3.add(currentPosition,currentPosition,moveAmount);
            this.node.setPosition(currentPosition);
            const targetRotation = new Vec3(0,135,0);
            this.node.eulerAngles= targetRotation;
        }
        if(this.isLeftKeyPressed && this.node.position.x>-4.5){
            const currentPosition = this.node.position;
            const moveAmount = new Vec3(-0.1,0,0);
            Vec3.add(currentPosition,currentPosition,moveAmount);
            this.node.setPosition(currentPosition);
            const targetRotation = new Vec3(0,225,0);
            this.node.eulerAngles= targetRotation;   
        }
    }
}


