System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, _decorator, input, Component, Input, KeyCode, Vec3, Label, Collider, _dec, _dec2, _class, _class2, _descriptor, _crd, ccclass, property, PlayerScript;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'transform-class-properties is enabled and runs after the decorators transform.'); }

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
      _decorator = _cc._decorator;
      input = _cc.input;
      Component = _cc.Component;
      Input = _cc.Input;
      KeyCode = _cc.KeyCode;
      Vec3 = _cc.Vec3;
      Label = _cc.Label;
      Collider = _cc.Collider;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "7ba33bI7uJDT5TwtrSWYefU", "PlayerScript", undefined);

      __checkObsolete__(['_decorator', 'input', 'Component', 'Node', 'Input', 'EventKeyboard', 'KeyCode', 'Event', 'Vec3', 'Label', 'Collider', 'ICollisionEvent']);

      ({
        ccclass,
        property
      } = _decorator);

      _export("PlayerScript", PlayerScript = (_dec = ccclass('PlayerScript'), _dec2 = property(Label), _dec(_class = (_class2 = class PlayerScript extends Component {
        constructor() {
          super(...arguments);
          this.isRightKeyPressed = false;
          this.isLeftKeyPressed = false;
          this.score = 0;

          _initializerDefineProperty(this, "scoreLabel", _descriptor, this);
        }

        onLoad() {
          input.on(Input.EventType.KEY_DOWN, this.onKeyDown, this);
          input.on(Input.EventType.KEY_UP, this.onKeyUp, this);
        }

        onDestroy() {
          input.off(Input.EventType.KEY_DOWN, this.onKeyDown, this);
          input.off(Input.EventType.KEY_UP, this.onKeyUp, this);
        }

        onKeyDown(event) {
          switch (event.keyCode) {
            case KeyCode.ARROW_LEFT:
              console.log("left key pressed");
              this.isLeftKeyPressed = true;
              break;

            case KeyCode.ARROW_RIGHT:
              console.log("right key pressed");
              this.isRightKeyPressed = true;
              break;
          }
        }

        onKeyUp(event) {
          var newTargetRotation = new Vec3(0, 180, 0);

          switch (event.keyCode) {
            case KeyCode.ARROW_LEFT:
              console.log("left key released");
              this.isLeftKeyPressed = false;
              this.node.eulerAngles = newTargetRotation;
              break;

            case KeyCode.ARROW_RIGHT:
              console.log("right key released");
              this.isRightKeyPressed = false;
              this.node.eulerAngles = newTargetRotation;
              break;
          }
        }

        start() {
          var collider = this.node.getComponent(Collider);
          collider.on("onCollisionStay", this.onCollision, this);
          collider.on("onCollisionEnter", this.onCollisionEnter, this);
          collider.on("onCollisionExit", this.onCollisionExit, this);
        }

        onCollision(event) {
          console.log(event.type, event + " collision stay");
        }

        onCollisionEnter(event) {
          console.log(event.type, event + " collision Enter");
          this.addScore();
        }

        onCollisionExit(event) {
          console.log(event.type, event + " collision Exit");
        }

        addScore() {
          this.score++;
          this.scoreLabel.string = "Score : " + this.score;
        }

        update(deltaTime) {
          var currentPosition = this.node.position;
          var moveAmount = new Vec3(0, 0, -0.1);
          Vec3.add(currentPosition, currentPosition, moveAmount);
          this.node.setPosition(currentPosition);

          if (this.isRightKeyPressed && this.node.position.x < 4.5) {
            var _currentPosition = this.node.position;

            var _moveAmount = new Vec3(0.1, 0, 0);

            Vec3.add(_currentPosition, _currentPosition, _moveAmount);
            this.node.setPosition(_currentPosition);
            var targetRotation = new Vec3(0, 135, 0);
            this.node.eulerAngles = targetRotation;
          }

          if (this.isLeftKeyPressed && this.node.position.x > -4.5) {
            var _currentPosition2 = this.node.position;

            var _moveAmount2 = new Vec3(-0.1, 0, 0);

            Vec3.add(_currentPosition2, _currentPosition2, _moveAmount2);
            this.node.setPosition(_currentPosition2);

            var _targetRotation = new Vec3(0, 225, 0);

            this.node.eulerAngles = _targetRotation;
          }
        }

      }, (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "scoreLabel", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      })), _class2)) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=91bd02f0f9b94bdf3800de802d880d639f5b1ee0.js.map