import { _decorator, Component, instantiate,
     Node, Prefab, Vec3, Label } from 'cc';
import { PlayerController } from './PlayerController';
const { ccclass, property } = _decorator;
enum BlockType{
        BT_NONE,
        BT_STONE,
};

enum GameState{
    GS_INIT,
    GS_PLAYING,
    GS_END,
};

@ccclass('GameManager')
export class GameManager extends Component {
    //cube prefab
    @property({type:Prefab})
    public cubePrfb: Prefab | null = null;

    // reference to the PlayerController
    @property({type:PlayerController})
    public playerCtrl: PlayerController | null = null;
//reference to the start menu
    @property({type:Node})
    public startMenu: Node |null = null;

    @property({type:Node})
    public oneStep:Node |null = null;


    @property({type:Node})
    public twoStep:Node |null = null;

    //total length of the road
    public roadLength = 50;
    private _road:BlockType[] = [];


    //Label for the steps
    @property({type:Label})
    public stepsLabel:Label|null = null;
    start() {
        //current state is initiliazation
       this.curState = GameState.GS_INIT;
       this.playerCtrl?.node.on("JumpEnd",this.onPlayerJumpEnd,this);
    }
    onPlayerJumpEnd(moveIndex:number){
        if(this.stepsLabel){
//casting to string from number, make sure we always score up to 50
            this.stepsLabel.string  = ''+(moveIndex >= this.roadLength?this.roadLength:moveIndex);
        }
        this.checkResult(moveIndex);
    }

    init(){
        if(this.startMenu){//the menu is true and not null
            this.startMenu.active = true;//enables it 
        }
        //disabling buttons
        if(this.oneStep){
            this.oneStep.active = false;
        }
        if(this.twoStep){
            this.twoStep.active = false;
        }
       
      

        this.generateRoad();//generate road
        if(this.playerCtrl){
            //switch off mouse input
            this.playerCtrl.setInputActive(false);
            //reset player position to 0,0,0
            this.playerCtrl.node.setPosition(Vec3.ZERO);
            this.playerCtrl.reset();//moveIndex = 0
        }
        
    }
    set curState(value:GameState){
        switch(value){
            case GameState.GS_INIT:
                this.init();//execute initialisation
                break;
            case GameState.GS_PLAYING:
                if(this.startMenu){
                    //disables the start menu
                    this.startMenu.active = false;
                }
                if(this.stepsLabel){
                    //reset to zero at the start of play
                    this.stepsLabel.string = '0';
                }
                setTimeout(()=>{
                    if(this.playerCtrl){
                        //enable the input
                        this.playerCtrl.setInputActive(true);
                    }
                },0.1);//enable a small delay

                //ENABLING THE BUTTONS
                if(this.oneStep){
                    this.oneStep.active = true;
                }
                if(this.twoStep){
                    this.twoStep.active = true;
                }
               
                break;
            case GameState.GS_END:
                break;

        }
    }
    onStartButtonClicked(){
        this.curState = GameState.GS_PLAYING;
    }
    checkResult(moveIndex:number){
        //player position is not at beyond the end of the road
        if(moveIndex<this.roadLength){
            //check if the player is not on a road
            if(this._road[moveIndex] == BlockType.BT_NONE){
                this.curState = GameState.GS_INIT;
            }
        }else{//player is beyond the road
            this.curState = GameState.GS_INIT;
        }
    }
    generateRoad(){
        //PRevent using old track
        this.node.removeAllChildren();
        this._road = [];

        //First position has to be a stone
        this._road.push(BlockType.BT_STONE);

        for(let i = 1; i<this.roadLength;i++){
            //if the previous position is an empty space
            if(this._road[i-1]===BlockType.BT_NONE)
            {
                //then this position has to be a stone 1
                this._road.push(BlockType.BT_STONE);
            }else{
                //randomize between 0 and 1
                this._road.push(Math.floor(Math.random()*2));
            }
        }
        //Generate tracks based on the runway
        for(let j = 0; j<this._road.length;j++){
            let block:Node = this.spawnBlockByType(this._road[j]);

            if(block){
                this.node.addChild(block);
                block.setPosition(j,-1.5,0);
            }
        }
    }

    spawnBlockByType(type:BlockType){
        if(!this.cubePrfb)
        {
            return null;
        }
        let block:Node |null = null;
        //we can generate the road for real roads (1)
        switch(type)
        {
            case BlockType.BT_STONE:
                //instantiate block
                block = instantiate(this.cubePrfb);
                break;
        }
        return block;
    }
    update(deltaTime: number) {
        
    }
}


