import { _decorator, Component, EventMouse, input, Input, Node, Vec3, Animation, SkeletalAnimation } from 'cc';
const { ccclass, property } = _decorator;

@ccclass('PlayerController')
export class PlayerController extends Component {

    //Animation Body
   // @property({type:Animation})
   // public BodyAnim: Animation | null = null;

   //skeletal animations
   @property({type:SkeletalAnimation})
   public CocosAnim: SkeletalAnimation|null = null;
    //check if player is jumping
    private _startJump:boolean = false;

    // The Jump Step (1 or 2 )
    private _jumpStep:number = 0;

    // The current position of the player
    private _curPos:Vec3 = new Vec3();

    // the target position of the player
    private _targetPos:Vec3 = new Vec3();

    //total jump time
    private _jumpTime:number = 0.5;

    //current jump speed
    private _curJumpSpeed:number =0;

    //current jump time
    private _curJumpTime:number = 0;

    //The difference of the current frame movement position during a jump
    private _deltaPos:Vec3 = new Vec3(0,0,0);

    //track the number of steps
    private _curMoveIndex = 0;
    start() {
        //listen for click event
        //input.on(Input.EventType.MOUSE_UP,this.onMouseUp,this);
    }
    setInputActive(active:boolean){//true or false
        if(active){
            //switch on mouse event listener
            input.on(Input.EventType.MOUSE_UP,this.onMouseUp,this);
        }else{
            //switch off mouse event listener
            input.off(Input.EventType.MOUSE_UP,this.onMouseUp,this);
        }
    }
    leftButton(){
        //left button clicked
        this.jumpByStep(1);
    }
    rightButton(){
        //right button clicked
        this.jumpByStep(2);
    }
    onMouseUp(event:EventMouse)
    {
//check if the user clicked the left (0) or the right (2) mouse button
        if(event.getButton()===0)//checks for left
        {
            this.jumpByStep(1);
        }
        else if(event.getButton()===2)//checks for right
        {
            this.jumpByStep(2);
        }
    }
    reset(){
        this._curMoveIndex = 0;//when the game is over
    }
    jumpByStep(step:number)
    {
        if(this._startJump)//if the player is already jumping
        {
// then we make sure the function does not make another jump
            return;
        }
//the following code only runs if the player is not jumping currently
        //so that no other jump runs together
        this._startJump = true;
        // based on left or right click
        this._jumpStep = step;
        // Reset Jump time
        this._curJumpTime = 0;
        // current jump step
        this._curJumpSpeed = this._jumpStep/this._jumpTime;
        //get the position of the player
        this.node.getPosition(this._curPos);
        Vec3.add(this._targetPos,this._curPos, new Vec3(this._jumpStep,0,0));
        

        //SKELETAL ANIMATION 
        if(this.CocosAnim){
            this.CocosAnim.getState('cocos_anim_jump').speed = 3.5;
            this.CocosAnim.play('cocos_anim_jump');
        }
        //Play Animation
       /* if(this.BodyAnim){
            if(step === 1){
                this.BodyAnim.play("oneStep");
            }else if(step === 2){
                this.BodyAnim.play("twoStep");
            }
        }*/
    //adds 1 or 2 to the current # of steps
        this._curMoveIndex += step;
    }
    onOnceJumpEnd(){
        if(this.CocosAnim){
            this.CocosAnim.play('cocos_anim_idle');
        }
        //custom event
        this.node.emit('JumpEnd',this._curMoveIndex);
    }

    update(deltaTime: number) {
        if(this._startJump)// if _startJump is true
        {
                //Jump time = last jump time + frame interval
                this._curJumpTime +=deltaTime;
                if(this._curJumpTime>this._jumpTime)
                { //the jump has ended

    //places the character where they should be at the end of a jump
                    this.node.setPosition(this._targetPos);
    // make sure the jump state says we are not jumping
                    this._startJump = false;
                    this.onOnceJumpEnd();
                    
                }else{
                    //still jumping
                    //tweening = making smooth transitions between frames
    //we have the player's position
                    this.node.getPosition(this._curPos);
    // So that we know the length of the frame to displace
                    this._deltaPos.x = this._curJumpSpeed * deltaTime;
    //setting the current position  by adding the old current 
    //position plus the delta position (difference)
                    Vec3.add(this._curPos,this._curPos,this._deltaPos);
    //set the node to a new position
                    this.node.setPosition(this._curPos);
                }
        }
    }
}


