System.register(["cc"], function (_export, _context) {
  "use strict";

  var _cclegacy, __checkObsolete__, __checkObsoleteInNamespace__, _decorator, Component, input, Input, Vec3, SkeletalAnimation, _dec, _dec2, _class, _class2, _descriptor, _crd, ccclass, property, PlayerController;

  function _initializerDefineProperty(target, property, descriptor, context) { if (!descriptor) return; Object.defineProperty(target, property, { enumerable: descriptor.enumerable, configurable: descriptor.configurable, writable: descriptor.writable, value: descriptor.initializer ? descriptor.initializer.call(context) : void 0 }); }

  function _applyDecoratedDescriptor(target, property, decorators, descriptor, context) { var desc = {}; Object.keys(descriptor).forEach(function (key) { desc[key] = descriptor[key]; }); desc.enumerable = !!desc.enumerable; desc.configurable = !!desc.configurable; if ('value' in desc || desc.initializer) { desc.writable = true; } desc = decorators.slice().reverse().reduce(function (desc, decorator) { return decorator(target, property, desc) || desc; }, desc); if (context && desc.initializer !== void 0) { desc.value = desc.initializer ? desc.initializer.call(context) : void 0; desc.initializer = undefined; } if (desc.initializer === void 0) { Object.defineProperty(target, property, desc); desc = null; } return desc; }

  function _initializerWarningHelper(descriptor, context) { throw new Error('Decorating class property failed. Please ensure that ' + 'proposal-class-properties is enabled and runs after the decorators transform.'); }

  return {
    setters: [function (_cc) {
      _cclegacy = _cc.cclegacy;
      __checkObsolete__ = _cc.__checkObsolete__;
      __checkObsoleteInNamespace__ = _cc.__checkObsoleteInNamespace__;
      _decorator = _cc._decorator;
      Component = _cc.Component;
      input = _cc.input;
      Input = _cc.Input;
      Vec3 = _cc.Vec3;
      SkeletalAnimation = _cc.SkeletalAnimation;
    }],
    execute: function () {
      _crd = true;

      _cclegacy._RF.push({}, "3dc0f7EmZ9NKpd3mHnwhtdT", "PlayerController", undefined);

      __checkObsolete__(['_decorator', 'Component', 'EventMouse', 'input', 'Input', 'Node', 'Vec3', 'Animation', 'SkeletalAnimation']);

      ({
        ccclass,
        property
      } = _decorator);

      _export("PlayerController", PlayerController = (_dec = ccclass('PlayerController'), _dec2 = property({
        type: SkeletalAnimation
      }), _dec(_class = (_class2 = class PlayerController extends Component {
        constructor() {
          super(...arguments);

          _initializerDefineProperty(this, "CocosAnim", _descriptor, this);

          this._startJump = false;
          this._jumpStep = 0;
          this._curPos = new Vec3();
          this._targetPos = new Vec3();
          this._jumpTime = 0.1;
          this._curJumpSpeed = 0;
          this._curJumpTime = 0;
          this._deltaPos = new Vec3(0, 0, 0);
          this._curMoveIndex = 0;
        }

        start() {//listen for click event
          //input.on(Input.EventType.MOUSE_UP,this.onMouseUp,this);
        }

        setInputActive(active) {
          //true or false
          if (active) {
            input.on(Input.EventType.MOUSE_UP, this.onMouseUp, this); //switch on mouse event listener
          } else {
            input.off(Input.EventType.MOUSE_UP, this.onMouseUp, this); //switch off mouse event listener
          }
        }

        onMouseUp(event) {
          //check if the user clicked the left (0) or the right (2) mouse button
          if (event.getButton() === 0) //checks for left
            {
              this.jumpByStep(1);
            } else if (event.getButton() === 2) //checks for right
            {
              this.jumpByStep(2);
            }
        }

        reset() {
          this._curMoveIndex = 0; //when the game is over
        }

        jumpByStep(step) {
          if (this._startJump) //if the player is already jumping
            {
              return; // then we make sure the function does not make another jump
            } //the following code only runs if the player is not jumping currently


          this._startJump = true; //so that no other jump runs together

          this._jumpStep = step; // based on left or right click

          this._curJumpTime = 0; // Reset Jump time

          this._curJumpSpeed = this._jumpStep / this._jumpTime; // current jump step

          this.node.getPosition(this._curPos); //get the position of the player

          Vec3.add(this._targetPos, this._curPos, new Vec3(this._jumpStep, 0, 0)); //animation time

          if (this.CocosAnim) {
            this.CocosAnim.getState('cocos_anim_jump').speed = 0.5;
            this.CocosAnim.play('cocos_anim_jump');
          } //Play Animation

          /* if(this.BodyAnim){
               if(step === 1){
                   this.BodyAnim.play("oneStep");
               }else if(step === 2){
                   this.BodyAnim.play("twoStep");
               }
           }*/


          this._curMoveIndex += step; //adds 1 or 2 to the current # of steps
        }

        onOnceJumpEnd() {
          if (this.CocosAnim) {
            this.CocosAnim.play('cocos_anim_idle');
          }

          this.node.emit('JumpEnd', this._curMoveIndex); //custom event
        }

        update(deltaTime) {
          if (this._startJump) // if _startJump is true
            {
              //Jump time = last jump time + frame interval
              this._curJumpTime += deltaTime;

              if (this._curJumpTime > this._jumpTime) {
                //the jump has ended
                this.node.setPosition(this._targetPos); //places the character where they should be at the end of a jump

                this._startJump = false; // make sure the jump state says we are not jumping

                this.onOnceJumpEnd();
              } else {
                //still jumping
                //tweening = making smooth transitions between frames
                this.node.getPosition(this._curPos); //we have the player's position

                this._deltaPos.x = this._curJumpSpeed * deltaTime; // So that we know the length of the frame to displace

                Vec3.add(this._curPos, this._curPos, this._deltaPos); //setting the current position  by adding the old current position plus the delta position (difference)

                this.node.setPosition(this._curPos); //set the node to a new position
              }
            }
        }

      }, (_descriptor = _applyDecoratedDescriptor(_class2.prototype, "CocosAnim", [_dec2], {
        configurable: true,
        enumerable: true,
        writable: true,
        initializer: function initializer() {
          return null;
        }
      })), _class2)) || _class));

      _cclegacy._RF.pop();

      _crd = false;
    }
  };
});
//# sourceMappingURL=5cee73bcd165b4dad886be962dd521a57a713834.js.map